﻿IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_importrandompin]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_importrandompin]
GO
CREATE PROCEDURE [dbo].[Sp_importrandompin](
                @ProjectId     INT,
                @userId        INT,
                @resRespondent VARCHAR(10),
                @mask          VARCHAR(20),
                @pinQuestion   VARCHAR(32))
AS
  DECLARE  @loopCount INT
  SET @loopCount = 0
  DECLARE  @pin VARCHAR(20)
  SET @pin = ''
  WHILE 1 = 1
    BEGIN
      EXEC Sp_generaterandompin
        @mask ,
        @pin OUTPUT
      DECLARE  @pinExists INT
      SELECT @pinExists = Count(rsppin)
      FROM   respondentpin
      WHERE  rsppin = @pin
      IF @pinExists = 0
        BEGIN
          UPDATE respondentpin
          SET    rsppin = @pin
          WHERE  rsprespondent = @resRespondent
          IF @@ROWCOUNT = 0
            INSERT INTO respondentpin
                       (rsprespondent,
                        rsppin,
                        projectid,
                        modifiedby,
                        modified)
            VALUES     (@resRespondent,
                        @pin,
                        @ProjectId,
                        @userId,
                        Getutcdate())
          BREAK;
        END
      SET @loopCount = @loopCount + 1
      IF @loopCount = 100
        BEGIN
          DECLARE  @errormsg VARCHAR(256)
          SET @errormsg = 'VOXCOERROR_1001 Unable to generate PIN with mask ' + @mask
          RAISERROR (@errormsg,16,1)
          RETURN
        END
    END
  IF @pinQuestion IS NOT NULL
     AND @pinQuestion <> ''
    BEGIN
      IF @pinQuestion = '$N'
        BEGIN
          UPDATE respondent
          SET    resphone = @pin
          WHERE  resrespondent = @resrespondent
        END
      ELSE
        BEGIN
          UPDATE response
          SET    rpscontent = @pin, projectId = @projectId, modifiedBy = @userId, modified = GetUtcDate()
          WHERE  rpsquestion = @pinQuestion
                 AND rpsmention = 1
                 AND rpsmatrix = 1
                 AND rpstype = 0
                 AND rpsrespondent = @resrespondent
          IF @@ROWCOUNT = 0
            INSERT INTO response
                       (rpsrespondent,
                        rpsquestion,
                        rpsmatrix,
                        rpsmention,
                        rpscontent,
                        rpsopened,
                        rpstype,
						projectId,
						modifiedBy,
						modified)
            VALUES     (@resrespondent,
                        @pinQuestion,
                        1,
                        1,
                        @pin,
                        NULL,
                        0,
						@ProjectId,
						@userId,
                        Getutcdate())
        END
    END
GO
